# Libraririe de détermination des paramètres de configuration PWM D3

# La fonction determinerParametres() tente de trouver les meilleurs...
#...parametres de configuration pour une frequence de sortie donne et...
#...un rapport cylique fixe de 0.1.
#
# La fonction determinerParametres() va tester plusieurs configuration...
#...possible et retourner la meilleur.
# Si aucune solution n'est trouve, la fonction retourne False.

def determinerParametres(frequenceSouhaite=-1,dutyCycle=0.5):

    if type(frequenceSouhaite).__name__ != 'int' and  type(frequenceSouhaite).__name__ != 'float' :
        print("determinerParametres, paramètre invalide !")
        return False

    pwmTableInfo = [
        [ 1024 ,    0.000128 ,      30.637 ,    3906.25 ] ,
        [ 256 ,     0.000032 ,      122.594 ,   15625   ] ,
        [ 128 ,     0.000016 ,      245.098 ,   31250   ] ,
        [ 64 ,      0.000008 ,      490.196 ,   62500   ] ,
        [ 32 ,      0.000004 ,      980,391 ,   125000  ] ,
        [ 8 ,       0.000001 ,      3921.568 ,  500000  ] ,
        [ 1 ,       0.000000125 ,   31372.549 , 4000000 ]
    ]
    
    # Retourner False pour signifier qu'aucune solution n'est trouvé pour...
    #...une fréquence au dela/en deca de ce qui est configurable.
    if frequenceSouhaite < pwmTableInfo[0][2] or frequenceSouhaite > pwmTableInfo[6][3] : return False

    # Plus d'une configuration est possible pour une fréquence donnée.
    # La section de code ci-apres tente de determiner si :
    # 1. Si une configuration permet l'exacte fréquence souhaité
    # 2. Test les differentes configurations possible et retourne la plus proche.
    #
    # Mettre la variable "afficherLesConfigurations" a True pour voir toutes les configurations trouvé
    # (n'a pas d'éffet si une configuration juste est trouvé)
    afficherLesConfigurations = False

    outCfg = (0,0,0,0)

    tempsPeriode = 1 / frequenceSouhaite

    for el in pwmTableInfo :
        if round(frequenceSouhaite*1E3) in range(round(el[2]*1E3),round(el[3]*1E3)+1):
            if tempsPeriode % el[1] == 0 :
                return (
                    el[0],
                    round(tempsPeriode/el[1]),
                    round((tempsPeriode/el[1]) * 0.5),
                    frequenceSouhaite,
                    ((1/frequenceSouhaite)/2)/(1/frequenceSouhaite)
                )
            else :
                periodValue =  round(tempsPeriode / el[1])
                if afficherLesConfigurations :
                    print(
                        "\nFréquence souhaité : "+str(frequenceSouhaite)+"\n"
                        "Configuration trouvé : "+"\n"
                        "\tprescaler : "+str(el[0])+"\n"
                        "\tpériode : "+str(periodValue)+"\n"
                        "\traport cyclique effectif : "+"{:.3f}".format(round(periodValue/2)/periodValue)+"\n"
                        "\tfréquence effective : "+"{:.3f}".format(1/(periodValue*el[1]))+" Hz\n"
                    )
                    
                if abs(frequenceSouhaite-(1/(periodValue*el[1]))) < abs(frequenceSouhaite-outCfg[3]):
                    outCfg = (
                        el[0] ,
                        periodValue ,
                        round(periodValue/2) ,
                        1/(periodValue*el[1]) ,
                        round(periodValue/2)/periodValue
                    )               

    return outCfg
